<?php
/**
 * Plugin Name: CGM Inclusio - Barrierefreiheit
 * Plugin URI:  https://cgm-design.de
 * Description: Integriert das CGM Inclusio Barrierefreiheits-Widget in Ihre WordPress-Webseite. Einfach UID eintragen und BFSG-konform werden.
 * Version:     1.0.0
 * Author:      CGM Design
 * Author URI:  https://cgm-design.de
 * License:     GPL2
 */

if (!defined('ABSPATH')) exit; // Sicherheits-Check

// 1. Menüpunkt im Admin-Bereich erstellen
function cgm_inclusio_menu() {
    add_options_page(
        'CGM Inclusio Einstellungen', 
        'CGM Inclusio', 
        'manage_options', 
        'cgm-inclusio', 
        'cgm_inclusio_settings_page'
    );
}
add_action('admin_menu', 'cgm_inclusio_menu');

// 2. Einstellungen registrieren
function cgm_inclusio_register_settings() {
    register_setting('cgm_inclusio_group', 'cgm_inclusio_uid');
}
add_action('admin_init', 'cgm_inclusio_register_settings');

// 3. Die Einstellungsseite (HTML)
function cgm_inclusio_settings_page() {
    ?>
    <div class="wrap">
        <h1>CGM Inclusio Integration</h1>
        <p>Geben Sie hier Ihre Widget-UID ein, die Sie im <a href="https://cgm-design.de/user/dashboard.php" target="_blank">CGM Dashboard</a> finden.</p>
        
        <form method="post" action="options.php">
            <?php settings_fields('cgm_inclusio_group'); ?>
            <?php do_settings_sections('cgm_inclusio_group'); ?>
            
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Widget UID</th>
                    <td>
                        <input type="text" name="cgm_inclusio_uid" value="<?php echo esc_attr(get_option('cgm_inclusio_uid')); ?>" class="regular-text" placeholder="z.B. w_65a4b123..." />
                        <p class="description">Diese ID finden Sie in Ihrem Dashboard unter "Konfiguration".</p>
                    </td>
                </tr>
            </table>
            
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// 4. Das Skript im Footer der Webseite ausgeben
function cgm_inclusio_inject_script() {
    $uid = get_option('cgm_inclusio_uid');
    
    // Nur ausgeben, wenn eine UID gespeichert ist
    if (!empty($uid)) {
        // Sicherstellen, dass keine schädlichen Zeichen enthalten sind
        $uid = sanitize_text_field($uid);
        ?>
        <!-- CGM Inclusio Widget -->
        <script src="https://cgm-design.de/widget.js?uid=<?php echo $uid; ?>" defer></script>
        <!-- End CGM Inclusio -->
        <?php
    }
}
add_action('wp_footer', 'cgm_inclusio_inject_script');
?>